//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//****************************************** 
/*							Pin Assignment
*********************************************************************
.........................-----------------............................
01.VSS.................01|O              |16.VDD
02.P00/XIN.............02|               |15.P40/AIN0/KWI0
03.P01/XOUT............03|     QFN-16    |14.P41/AIN1/KWI1
04.P10/RESETB..........04|               |13.P42/AIN2/KWI2
05.P71/TC01/PWM01B.....05|               |12.P43/AIN3/KWI3/VREF
06.P90/TX/RX...........06|     LQFP-16   |11.P74/DVOB/AIN8/SI/KWI13      
07.P91/RX/TX...........07|               |10.P76/INT3/SCLK/KWI15
08.P72/TCA0/PPGA0B.....08|	             |9.P70/TC00/PWM00B               
.........................-----------------............................
*********************************************************************/
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"
#include "iApp.h"
#include "OPmode.h"
#include "KWU.h"
#include "ExtINT.h"

//-- header guards --//


//-- function definition --//


//-- ȫֱ --//


//-- ȫֳ --//


//-- ȫֱ --//




void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR and P10/P40/P41 initialization during debugging ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR and P10/P40/P41 initialization during debugging
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt

//--------------------------------------------------------------------------------------------------//
//	Please set the external crystal (HXTAL/LXTAL) from <OPmode.h> and refer to the following instructions:
//.....................................................................................
//#undef	XTAL_High		// define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//#undef	XTAL_Low		// define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//.....................................................................................
//	please change the above program in the <OPmode.h> file
//	please pay attention to the external crystal switching in this document
//--------------------------------------------------------------------------------------------------//




//*********************************************************************
// 			: Each Mode Switch Sequence
//	NORMAL1	:----------------------------------------------------------
//			: --> NORMAL1
//			: --> IDLE0(INTTBT release)		--> NORMAL1
//			: --> IDLE1(Interrupt release)	--> NORMAL1
//			: --> STOP (be woken up)			--> NORMAL1
//	NORMAL2	:----------------------------------------------------------
//			: --> NORMAL2
//			: --> IDLE2(Interrupt release)			--> NORMAL2
//			: --> STOP (be woken up)			--> NORMAL2
//	SLOW2	:----------------------------------------------------------
//			: --> SLOW2
//	SLOW1	:----------------------------------------------------------
//			: --> SLOW1
//			: --> SLEEP0(INTTBT release)	--> SLOW1
//			: --> SLEEP1(Interrupt release)	--> SLOW1
//			: --> STOP  (be woken up)		--> SLOW1
//	--------:----------------------------------------------------------
//*********************************************************************


//----------------------------------------//
//	this example uses KWI5  STOP mode
	d_KWU_05_EnL;
//......|..| EnL/EnH/Dis: STOP mode release level, or Disable
//......| 00~15: KWU00~KWU15

//----------------------------------------//
//****** Power on Ϊ NORMAL1 mode ******//
//----------------------------------------//

//	NORMAL1 enter STOP mode ............
	__asm("CPL (_P7DR).0");
	Active_STOP;					// this example uses KWI5  STOP mode
	__asm("CPL (_P7DR).0");

//	NORMAL1 entry IDLE0 mode ............
	__asm("CPL (_P7DR).6");
	INTTBT_Init_OP();				// initial TBT timer setting
									// this example uses TBT interrupt to wake up from IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE0;					// TGHALT: (NORMAL1->IDLE0) / (SLOW1->SLEEP0) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P7DR).6");

//	NORMAL1 entry IDLE1 mode ............
	__asm("CPL (_P9DR).1");
	INTTBT_Init_OP();				// initial TBT timer setting
									// this example uses TBT interrupt to wake up from IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE1;					// IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P9DR).1");

//----------------------------------------//
//****** Entry NORMAL2 mode **************//
//----------------------------------------//
//	MQ6812 LIRC һϵΪ״̬
//	Ա change to NORMAL2 mode, ϵͳɲԤ reset
	OpMode_Change_to(iNor2);		// select the operating mode to be operated to one of (iNor1/iNor2/iSlow2/iSlow1)

//	NORMAL2 enter STOP mode ............
	__asm("CPL (_P7DR).0");
	Active_STOP;					// this example uses KWI5  STOP mode
	__asm("CPL (_P7DR).0");

//	NORMAL2 entry IDLE2 mode ............
	__asm("CPL (_P9DR).1");
	INTTBT_Init_OP();				// initial TBT timer setting
									// this example uses TBT interrupt to wake up from IDLE1/IDLE2/SLEEP1 mode
	Active_IDLE2;					// IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P9DR).1");

//----------------------------------------//
//****** Entry SLOW2 mode ****************//
//----------------------------------------//
	OpMode_Change_to(iSlow2);		// select the operating mode to be operated to one of (iNor1/iNor2/iSlow2/iSlow1)

//----------------------------------------//
//****** Entry SLOW1 mode ****************//
//----------------------------------------//
	OpMode_Change_to(iSlow1);		// select the operating mode to be operated to one of (iNor1/iNor2/iSlow2/iSlow1)

//	SLOW1 enter STOP mode ............
	__asm("CPL (_P7DR).0");
	Active_STOP;					// this example uses KWI5  STOP mode
	__asm("CPL (_P7DR).0");

//	SLOW1 entry SLEEP0 mode ............
	__asm("CPL (_P7DR).6");
	INTTBT_Init_OP();				// initial TBT timer setting
									// this example uses TBT interrupt to wake up from IDLE1/IDLE2/SLEEP1 mode
	Active_SLEEP0;					// TGHALT: (NORMAL1->IDLE0) / (SLOW1->SLEEP0) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P7DR).6");

//	SLOW1 entry SLEEP1 mode ............
	__asm("CPL (_P9DR).1");
	INTTBT_Init_OP();				// initial TBT timer setting
									// this example uses TBT interrupt to wake up from IDLE1/IDLE2/SLEEP1 mode
	Active_SLEEP1;					// IDLE: (NORMAL1->IDLE1) / (NORMAL2->IDLE2) / (SLOW1->SLEEP1) mode
	Disable_INTTBT_OP();			// clear INTTBT setting after release IDLE0/SLEEP0 mode
	__asm("CPL (_P9DR).1");
//----------------------------------------//
//----------------------------------------//


	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
		__asm("CPL (_P7DR).6");
		__asm("CPL (_P7DR).6");
		__asm("CPL (_P7DR).6");
		__asm("CPL (_P7DR).6");
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


